<?php

/**
 * @package     Formea.Plugin
 * @subpackage  element
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
// no direct access
defined('_JEXEC') or die();

use Joomla\Component\Formea\Site\Libraries\FormeaEltype;

class FormeaTextarea extends FormeaEltype
{
  public function __construct($config = [])
  {
    parent::__construct($config);
  }

  public function getInput($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
  {
    if (is_string($class)) {
      $class = [$class];
    }
    $themeClass = $this->getThemeClass();
    if (empty($langTagUnderscore)) {
      $langTagUnderscore = $this->langTagUnderscore;
    }

    $classAttr = [];

    $classAttr[] = $themeClass->getInputClass();
    if (!empty($class)) {
      $classAttr = array_merge($classAttr, $class);
    }

    $input = '<textarea class="' . implode(' ', $classAttr) . '" ';
    if (!$preview) {
      $input .= 'name="' . $this->formatElementName() . '"';
    }
    if (isset($inputAttributes['placeholder'])) {
      $input .= 'placeholder="' . $inputAttributes['placeholder'] . '" ';
    }

    $input .= 'id="' . $this->formatElementId() . '" >';
    if (isset($inputAttributes['value'])) {
      $input .= $inputAttributes['value'];
    }
    $input .= '</textarea>';


    return $input;
  }
}
