<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Parser\CommentStrategy;

use Egulias\EmailValidator\EmailLexer;
use Egulias\EmailValidator\Result\Result;
use Egulias\EmailValidator\Result\ValidEmail;
use Egulias\EmailValidator\Result\InvalidEmail;
use Egulias\EmailValidator\Result\Reason\ExpectingATEXT;

class DomainComment implements CommentStrategy
{
	public function exitCondition(EmailLexer $lexer, int $openedParenthesis): bool
	{
		if (($openedParenthesis === 0 && $lexer->isNextToken(EmailLexer::S_DOT))) { // || !$internalLexer->moveNext()) {
			return false;
		}

		return true;
	}

	public function endOfLoopValidations(EmailLexer $lexer): Result
	{
		//test for end of string
		if (!$lexer->isNextToken(EmailLexer::S_DOT)) {
			return new InvalidEmail(new ExpectingATEXT('DOT not found near CLOSEPARENTHESIS'), ((array) $lexer->token)['value']);
		}
		//add warning
		//Address is valid within the message but cannot be used unmodified for the envelope
		return new ValidEmail();
	}

	public function getWarnings(): array
	{
		return [];
	}
}
