<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Validation\Extra;

use LogicException;
use Spoofchecker;
use Egulias\EmailValidator\EmailLexer;
use Egulias\EmailValidator\Result\SpoofEmail;
use Egulias\EmailValidator\Result\InvalidEmail;
use Egulias\EmailValidator\Validation\EmailValidation;

class SpoofCheckValidation implements EmailValidation
{
	/**
	 * @var InvalidEmail|null
	 */
	private $error;

	public function __construct()
	{
		if (!extension_loaded('intl')) {
			throw new LogicException(sprintf('The %s class requires the Intl extension.', __CLASS__));
		}
	}

	/**
	 * @psalm-suppress InvalidArgument
	 */
	public function isValid(string $email, EmailLexer $emailLexer): bool
	{
		$checker = new Spoofchecker();
		$checker->setChecks(Spoofchecker::SINGLE_SCRIPT);

		if ($checker->isSuspicious($email)) {
			$this->error = new SpoofEmail();
		}

		return $this->error === null;
	}

	/**
	 * @return InvalidEmail
	 */
	public function getError(): ?InvalidEmail
	{
		return $this->error;
	}

	public function getWarnings(): array
	{
		return [];
	}
}
