<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Warning;

abstract class Warning
{
	public const CODE = 0;

	/**
	 * @var string
	 */
	protected $message = '';

	/**
	 * @var int
	 */
	protected $rfcNumber = 0;

	/**
	 * @return string
	 */
	public function message()
	{
		return $this->message;
	}

	/**
	 * @return int
	 */
	public function code()
	{
		return self::CODE;
	}

	/**
	 * @return int
	 */
	public function RFCNumber()
	{
		return $this->rfcNumber;
	}

	public function __toString()
	{
		return $this->message() . " rfc: " . $this->rfcNumber . "internal code: " . static::CODE;
	}
}
