<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Categories\CategoryNode;
use Joomla\CMS\Language\Multilanguage;

/**
 * Formea Component Route Helper
 *
 * @static
 * @package     Joomla.Site
 * @subpackage  com_formea
 * @since       1.5
 */
abstract class Route
{
	/**
	 * Get the URL route for a formeas from a formea ID, formeas category ID and language
	 *
	 * @param   integer  $id        The id of the formeas
	 * @param   integer  $catid     The id of the formeas's category
	 * @param   mixed    $language  The id of the language being used.
	 *
	 * @return  string  The link to the formeas
	 *
	 * @since   1.5
	 */
	public static function getFormeaRoute($id, $catid, $language = 0)
	{
		// Create the link
		$link = 'index.php?option=com_formea&view=formea&id=' . $id;

		if ($catid > 1) {
			$link .= '&catid=' . $catid;
		}

		if ($language && $language !== '*' && Multilanguage::isEnabled()) {
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Get the URL route for a formeas category from a formeas category ID and language
	 *
	 * @param   mixed  $catid     The id of the formeas's category either an integer id or an instance of CategoryNode
	 * @param   mixed  $language  The id of the language being used.
	 *
	 * @return  string  The link to the formeas
	 *
	 * @since   1.5
	 */
	public static function getCategoryRoute($catid, $language = 0)
	{
		if ($catid instanceof CategoryNode) {
			$id = $catid->id;
		} else {
			$id = (int) $catid;
		}

		if ($id < 1) {
			$link = '';
		} else {
			// Create the link
			$link = 'index.php?option=com_formea&view=category&id=' . $id;

			if ($language && $language !== '*' && Multilanguage::isEnabled()) {
				$link .= '&lang=' . $language;
			}
		}

		return $link;
	}
}
