<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */


namespace Joomla\Component\Formea\Site\Libraries;

defined('_JEXEC') or die;

use Feseur\Library\FsrResponse;

class FormeaSubmissionElement
{
  public $form_id;
  public $form_alias;
  public $element_id;
  public $labelSettings;
  public $type;
  public $group_id;
  public $page_id;
  public $title;
  public $alias;
  public $state;
  public $group_type;
  public $group_state;
  public $submitted_value = '';
  public $setIndex = -1;
  public $found = false;

  public $is_link = 0;
  public $link_path = [];
  public $dir_path = [];

  public $validation_error = false;

  /**
   * @var FsrResponse | null
   * @since 1.0.5
   */
  public $validation_result = null;
  public $byPassValidation = false;

  public $caption = '';
  public $skip_value_store = false;

  /**
   * @var array
   * @since 1.0.7
   */
  public $error_classes = [];

  /**
   * @var array
   * @since 1.0.7
   */
  public $classes = [];

  public function __construct($config = [])
  {
    foreach ($config as $prop => $value) {
      $this->set($prop, $value);
    }
  }

  public function set($prop, $value)
  {
    $fields = $this->_fields();
    if (in_array($prop, $fields)) {
      $this->{$prop} = $value;
    }
  }

  protected function _fields()
  {
    return [
      'form_id',
      'form_alias',
      'element_id',
      'labelSettings',
      'type',
      'group_id',
      'page_id',
      'title',
      'alias',
      'state',
      'group_type',
      'group_state',
      'submitted_value',
      'setIndex',
      'found',
      'is_link',
      'link_path',
      'dir_path',
      'byPassValidation',
      'validation_error',
      'validation_result',
      'caption',
      'skip_value_store',
    ];
  }
}
