<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Site\View\Groupedelement;

defined('_JEXEC') or die;

use Feseur\Library\FsrResponse;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;


/**
 * HTML Formea View class for the Formea component
 *
 * @since  1.0.0
 */
class RawView extends BaseHtmlView
{
	public $element;

	public function display($tpl = null)
	{
		if (isset($this->element['html'])) {
			echo $this->element['html'];
		} else {
			echo '';
		}
		if (isset($this->element['scripts'])) {
			echo '<script type="text/javascript">';
			$totalScripts = count($this->element['scripts']);
			for ($i = 0; $i < $totalScripts; $i++) {
				echo $this->element['scripts'][$i];
			}
			echo '</script>';
		} else {
			echo '';
		}
	}
}
