<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Administrator\Controller;

defined('_JEXEC') or die;

use Exception;
use Feseur\Library\FsrResponse;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Joomla\Component\Formea\Administrator\Model\ThemeModel;
use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;

/**
 * Controller for a single formea
 *
 * @since  1.0
 */
class ThemeController extends FormController
{
  /**
   * The prefix to use with controller messages.
   *
   * @var    string
   * @since  1.0.0
   */
  protected $text_prefix = 'COM_FORMEA_THEME';

  public function save($key = null, $urlVar = null)
  {
    $saved = parent::save($key, $urlVar); // TODO: Change the autogenerated stub

  }

  /**
   * Method to run batch operations.
   *
   * @param   object  $model  The model.
   *
   * @return  boolean   True if successful, false otherwise and internal error is set.
   *
   * @since   1.0
   */
  public function batch($model = null)
  {
    $this->checkToken();

    $model = $this->getModel('Theme', 'Administrator', array());

    // Preset the redirect
    $this->setRedirect(Route::_('index.php?option=com_formea&view=themes' . $this->getRedirectToListAppend(), false));

    return parent::batch($model);
  }

  /**
   * Install a theme plugin
   */
  public function install()
  {
    $this->checkToken();
    $app    = Factory::getApplication();
    $plugin = $app->getInput()->files->getRaw('plugin_package', []);

    /** @var ThemeModel $model */
    $model = $this->getModel('Theme');

    try {
      if (empty($plugin)) {
        throw new Exception(Text::_('COM_FORMEA_NOT_FILE_UPLOADED'));
      }
      $model->install($plugin);
      $this->setRedirect(Route::_('index.php?option=com_formea&view=themes', false), Text::_('COM_FORMEA_THEME_PLUGIN_INSTALLED'));
    } catch (Exception $e) {
      $this->app->enqueueMessage($e->getMessage(), 'error');
      $this->setRedirect(Route::_('index.php?option=com_formea&view=themes', false), Text::_('COM_FORMEA_THEME_PLUGIN_INSTALL_ERROR'));
    }
  }

  public function getStyles()
  {
    $retObject = new FsrResponse();
    try {
      if (!$this->checkToken('GET')) {
        throw new Exception('Invalid token');
      }
      $theme_id = $this->input->getInt('id', 0);
      if ($theme_id < 1) {
        throw new Exception('No Theme ' . $theme_id);
      }
      $styles = FormeaGeneralHelper::getExtensionStyles($theme_id, 1);
      $retObject->setSuccess(true);
      $retObject->setResult([
        'styles' => $styles
      ]);
    } catch (Exception $e) {
      $retObject->setMsg($e->getMessage());
    }
    echo json_encode($retObject);
    $this->app->close();
  }
}
