<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Administrator\Field;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Database\DatabaseDriver;

/**
 * name Form Field class for the Genejunction component
 */
class FormeaListField extends ListField
{
	/**
	 * The name field type.
	 *
	 * @var    string
	 */
	protected $type = 'formeaList';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return  array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		$container = Factory::getContainer();
		/** @var DatabaseDriver $db */
		$db = $container->get('DatabaseDriver');
		$query = $db->getQuery(true);
		$query->select(['id', 'title']);
		$query->from($db->quoteName('#__formea_forms'));
		$query->where($db->quoteName('state') . ' = 1');
		$query->order('id ASC');
		$db->setQuery($query);
		$items   = $db->loadObjectList();
		$options = array();
		if ($items) {
			foreach ($items as $item) {
				$options[] = HTMLHelper::_('select.option', $item->id, ucwords($item->title));
			}
		}
		$options = array_merge(parent::getOptions(), $options);

		return $options;
	}
}
