<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Administrator\View;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;
use Joomla\Registry\Registry;


class FormeaView extends HtmlView
{

  /**
   * @var Registry
   * @since 1.0.0
   */
  public $formeaConfig;

  public function display($tpl = null)
  {
    if (!FormeaGeneralHelper::checkSystemPlg()) {
      $pluginLinkUrl = Route::_('index.php?option=com_plugins&view=plugins&filter[search]=formea');
      $pluginLink    = '<a class="text-danger text-decoration-underline" href="' . $pluginLinkUrl . '">System > Plugins > Formea System</a>';
      Factory::getApplication()->enqueueMessage(Text::sprintf('COM_FORMEA_PLG_SYSTEM_FORMEA_DISABLED_WARN_S', $pluginLink), 'error');
    }
    $this->formeaConfig = ComponentHelper::getParams('com_formea');
    parent::display($tpl);
    echo FormeaGeneralHelper::getFooterVersion();
  }
}
