<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Component\Formea\Administrator\View\Element\HtmlView;


/** @var HtmlView $this */

/** @var WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
	->useScript('form.validate');
$wa->useStyle('switcher');

HTMLHelper::_('script', 'com_formea/admin-formeas-letter.js', array('version' => 'auto', 'relative' => true));

$app                    = Factory::getApplication();
$input                  = $app->input;
$this->useCoreUI        = true;

// In case of modal
$isModal   = $input->get('layout') == 'modal' ? true : false;
$layout    = $isModal ? 'modal' : 'edit';
$tmpl      = $isModal || $input->get('tmpl', '') === 'component' ? '&tmpl=component' : '';
$totalLang = $this->totalLanguages;
$lTag      = str_replace('-', '_', $this->lang_tag);
?>

<form
	action="<?php echo Route::_('index.php?option=com_formea&view=eltype&layout=' . $layout . $tmpl . '&id=' . (int) $this->item->id); ?>"
	method="post" name="adminForm" id="formea-form" class="form-validate">
	<?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?>
	<div>

		<?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'details')); ?>
		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('COM_FORMEA_GENERAL')); ?>
		<div class="row">
			<div class="col-md-9">
				<?php
				if (!$this->elementType->config->details->enabled) {
				?>
					<div class="d-block bg-light p-3 rounded text-center text-muted">
						<?php echo Text::_('COM_FORMEA_ELEMENT_DETAIL_NOT_APPLICABLE'); ?>
					</div>
					<?php
				} else {
					if ($this->isMultiLang && $totalLang > 1) {
						echo HTMLHelper::_('uitab.startTabSet', 'langTab', array('active' => $lTag));
						for ($i = 0; $i < $totalLang; $i++) {
							$ltag = str_replace('-', '_', $this->languageLists[$i]->lang_code);
							echo HTMLHelper::_('uitab.addTab', 'langTab', $ltag, $this->languageLists[$i]->title);
							if (isset($this->elementTypeDetailConfig->caption) && $this->elementTypeDetailConfig->caption) {
								echo $this->form->renderField('caption', 'details.' . $ltag);
							}
							if (isset($this->elementTypeDetailConfig->placeholder) && $this->elementTypeDetailConfig->placeholder) {
								echo $this->form->renderField('placeholder', 'details.' . $ltag);
							}
							if (isset($this->elementTypeDetailConfig->description) && $this->elementTypeDetailConfig->description) {
					?>
								<div class="position-relative">
									<?php echo $this->form->renderField('description', 'details.' . $ltag); ?>
								</div>
				<?php }
							echo HTMLHelper::_('uitab.endTab');
						}
						echo HTMLHelper::_('uitab.endTabSet');
					} else {
						if (isset($this->elementTypeDetailConfig->caption) && $this->elementTypeDetailConfig->caption) {
							echo $this->form->renderField('caption', 'details.' . $lTag);
						}
						if (isset($this->elementTypeDetailConfig->placeholder) && $this->elementTypeDetailConfig->placeholder) {
							echo $this->form->renderField('placeholder', 'details.' . $lTag);
						}
						if (isset($this->elementTypeDetailConfig->description) && $this->elementTypeDetailConfig->description) {
							echo $this->form->renderField('description', 'details.' . $lTag);
						}
					}
				}
				?>
			</div>
			<div class="col-md-3">
				<?php echo $this->getForm()->renderField('state'); ?>
				<?php echo $this->getForm()->renderField('access_level'); ?>
				<?php echo $this->getForm()->renderField('publish_up'); ?>
				<?php echo $this->getForm()->renderField('publish_down'); ?>
				<?php echo $this->getForm()->renderField('created_date'); ?>
				<?php echo $this->getForm()->renderField('created_by'); ?>
				<?php echo $this->getForm()->renderField('modified_date'); ?>
				<?php echo $this->getForm()->renderField('modified_by'); ?>
			</div>
		</div>
		<?php echo HTMLHelper::_('uitab.endTab'); ?>
		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'valueFields', Text::_('COM_FORMEA_VALUE')); ?>
		<?php echo $this->loadTemplate('values'); ?>
		<?php echo HTMLHelper::_('uitab.endTab'); ?>
		<?php
		if ($this->elementType->config->validations->enabled) {
			echo HTMLHelper::_('uitab.addTab', 'myTab', 'validationFields', Text::_('COM_FORMEA_VALIDATION'));
			echo '<formea-field-validation></formea-field-validation>';
			echo HTMLHelper::_('uitab.endTab');
		}
		if ($this->elementType->config->attributes->enabled) {
			echo HTMLHelper::_('uitab.addTab', 'myTab', 'attributes', Text::_('COM_FORMEA_ATTRIBUTES'));
			echo $this->form->renderField('class', 'attributes');
			echo $this->form->renderField('size', 'attributes');
			echo $this->form->renderField('max_size', 'attributes');
			echo $this->form->renderField('additional_attr', 'attributes');
			echo HTMLHelper::_('uitab.endTab');
		} ?>

		<?php if ($this->hasElementConfig && $this->elementType->config->elementConfig->enabled): ?>
			<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'params', Text::sprintf('COM_FORMEA_ELEMENT_PARAMS', $this->elementType->name)); ?>
			<?php echo $this->loadTemplate('config'); ?>
			<?php echo HTMLHelper::_('uitab.endTab'); ?>
		<?php endif; ?>


		<?php echo HTMLHelper::_('uitab.endTabSet'); ?>
	</div>
	<?php echo $this->form->renderField('type'); ?>
	<?php echo $this->form->renderField('id'); ?>
	<input type="hidden" name="type" value="<?php echo $this->item->type; ?>">
	<input type="hidden" name="task" value="">
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
<script>
	window.addEventListener('DOMContentLoaded', function() {
		var el = document.getElementsByTagName('joomla-tab');
		if (el !== undefined) {
			if (el.length > 0) {
				for (var i = 0; i < el.length; i++) {
					el[i].addEventListener('joomla.tab.show', function() {
						window.dispatchEvent(new Event('resize'));
					});
				}
			}
		}
	});
</script>