<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Formea\Administrator\View\Elements\HtmlView;

$published = $this->state->get('filter.published');
$noUser    = true;
/** @var HtmlView $this */
$totalElTypes = count($this->elementTypes);
?>
<div class="d-block p-3" style="background-color: var(--template-bg-dark-5);">
	<div class="row g-2">
		<?php
		if ($totalElTypes < 1) {
		?>
			<div class="col-md-12">
				<div class="d-block py-5 text-center lead">
					<?php echo Text::_('COM_FORMEA_ELEMENT_CREATE_NO_ELTYPE'); ?>
				</div>
			</div>
			<?php } else {
			for ($i = 0; $i < $totalElTypes; $i++) {
				$image = $this->elementTypes[$i]->config->get('imageDetails.image', null);
			?>
				<div class="col-6 col-md-3">
					<a
						href="<?php echo Route::_('index.php?option=com_formea&task=element.edit&id=0&type=' . $this->elementTypes[$i]->name); ?>"
						class="card py-2 px-3 card-clickable card-body icn-container">
						<?php if (!empty($image)) {
							$imageType = (int) $this->elementTypes[$i]->config->get('imageDetails.imageType', 0);
						?>
							<div class="icn me-2">
								<img src="<?php echo Uri::root() . $image; ?>"
									class="img-fluid <?php echo ($imageType > 0) ? 'img-svg' : '' ?>"
									alt="">
							</div>
						<?php } ?>

						<?php echo Text::_($this->elementTypes[$i]->title); ?>
					</a>
				</div>
		<?php }
		}
		?>
	</div>
</div>