<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Component\Formea\Administrator\View\Formea\HtmlView;

/** @var HtmlView $this */
?>
<div class="no-tab-padding">
	<?php
	echo HTMLHelper::_('uitab.startTabSet', 'coreTabs', array('active' => $this->coreExtensions[0]->name, 'orientation' => 'vertical'));
	for ($i = 0; $i < $this->totalCoreExtensions; $i++) {
		echo HTMLHelper::_('uitab.addTab', 'coreTabs', $this->coreExtensions[$i]->name, Text::_($this->coreExtensions[$i]->title));
	?>
		<?php
		$overrideFile = FORMEA_CORE_PATH . '/' . $this->coreExtensions[$i]->name . '/administrator/tmpl/formea/edit_cores.php';

		if (is_file($overrideFile)) {
			echo \Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper::loadFormeaLayout($overrideFile, [
				'htmlForm' => $this->form,
				'coreExtension' => $this->coreExtensions[$i],
			]);
		} else { ?>
			<div class="d-block ps-3">
				<?php
				$fieldset = $this->form->getFieldset($this->coreExtensions[$i]->name);
				foreach ($fieldset as $field) {
					echo $field->renderField();
				}
				?>
			</div>
		<?php }
		?>


	<?php
		echo HTMLHelper::_('uitab.endTab');
	}
	echo HTMLHelper::_('uitab.endTabSet');
	?>
</div>