<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Component\Formea\Administrator\View\Formea\HtmlView;

/** @var HtmlView $this */
$totalLang = count($this->languageLists);
$lTag      = str_replace('-', '_', $this->lang_tag);
?>
<div class="row">
	<div class="col-md-9">
		<?php
		if ($this->isMultiLang && $totalLang > 1) {
			echo HTMLHelper::_('uitab.startTabSet', 'langTabSubmission', array('active' => $lTag));
			for ($i = 0; $i < $totalLang; $i++) {
				$ltag = str_replace('-', '_', $this->languageLists[$i]->lang_code);
				echo HTMLHelper::_('uitab.addTab', 'langTabSubmission', $ltag, $this->languageLists[$i]->title);
		?>
				<div class="d-block p-3">
					<?php
					echo $this->form->renderField('submission_msg', 'submission.' . $ltag);
					echo $this->form->renderField('global_error_msg', 'submission.' . $ltag);
					echo $this->form->renderField('limit_reach_msg', 'submission.' . $ltag);
					?>
				</div>
		<?php
				echo HTMLHelper::_('uitab.endTab');
			}
			echo HTMLHelper::_('uitab.endTabSet');
		} else {
			echo $this->form->renderField('submission_msg', 'submission.' . $lTag);
			echo $this->form->renderField('global_error_msg', 'submission.' . $lTag);
			echo $this->form->renderField('limit_reach_msg', 'submission.' . $lTag);
		}
		?>
	</div>
	<div class="col-md-3">
		<?php echo $this->form->renderField('allow_submission'); ?>
		<?php echo $this->form->renderField('limit_submission'); ?>
		<?php echo $this->form->renderField('submission_method', 'params'); ?>
		<?php echo $this->form->renderField('message_type', 'params'); ?>
		<?php echo $this->form->renderField('after_submission', 'params'); ?>
		<?php echo $this->form->renderField('redirect_url', 'params'); ?>
	</div>
</div>