<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Feseur\Library\FsrDate;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\User\User;
use Joomla\CMS\User\UserFactoryInterface;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;
use Joomla\Component\Formea\Administrator\View\Submission\HtmlView;
use Joomla\Component\Formea\Site\Libraries\Enums\SubmissionType;

/** @var HtmlView $this */

/** @var WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive');
$wa->useScript('bootstrap.popover');

$app   = Factory::getApplication();
$input = $app->input;

// In case of modal
$isModal       = $input->get('layout') == 'modal' ? true : false;
$layout        = $isModal ? 'modal' : 'edit';
$tmpl          = $isModal || $input->get('tmpl', '') === 'component' ? '&tmpl=component' : '';
$totalDetails  = count($this->item->details);
$dateSubmitted = new FsrDate($this->item->created_date);
$formeaConfig  = ComponentHelper::getParams('com_formea');
$emailStatus = FormeaHelper::extractSubmissionEmailStatus($this->item);
?>
<form
  action="<?php echo Route::_('index.php?option=com_formea&view=submission&layout=' . $layout . $tmpl . '&id=' . (int) $this->item->id); ?>"
  method="post" name="adminForm" id="formea-form" class="form-validate">
  <div class="row gx-2">
    <div class="col-md-8">
      <div class="card h-100">
        <table class="table rounded">
          <?php for ($i = 0; $i < $totalDetails; $i++) { ?>
            <tr>
              <th><?php echo $this->item->details[$i]->field_caption; ?></th>
              <td>
                <?php if ((int) $this->item->details[$i]->is_link == 1 && !empty($this->item->details[$i]->files)): ?>
                  <ul class="list-unstyled">
                    <?php foreach ($this->item->details[$i]->files as $file) { ?>
                      <li><a target="_blank" download href="<?php echo $file->url; ?>"><?php echo $file->name; ?></a>
                      </li>
                    <?php } ?>
                  </ul>
                <?php else: ?>
                  <?php echo $this->item->details[$i]->field_value; ?>
                <?php endif; ?>
              </td>
            </tr>
          <?php } ?>
        </table>
      </div>
    </div>
    <div class="col-md-4">
      <div class="list-group">
        <div class="list-group-item d-flex justify-content-between gap-2 align-items-center">
          <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_FORM_NAME'); ?></div>
          <div><?php echo $this->item->form_title; ?></div>
        </div>
        <div class="list-group-item d-flex justify-content-between gap-2 align-items-center">
          <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_SUBMITTED_BY'); ?></div>
          <div><?php
                if ($this->item->user_id < 1) {
                  echo Text::_('COM_FORMEA_GUEST');
                } else {
                  /** @var User $submitter */
                  $submitter = Factory::getContainer()->get(UserFactoryInterface::class)->loadUserById($this->item->user_id);
                  echo $submitter->get('name');
                }
                ?>
          </div>
        </div>
        <div class="list-group-item d-flex justify-content-between gap-2 align-items-center">
          <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_SUBMISSION_URL'); ?></div>
          <div><?php echo $this->item->submitted_url; ?>
          </div>
        </div>
        <div class="list-group-item d-flex justify-content-between gap-2 align-items-center">
          <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_DATE_SUBMITTED'); ?></div>
          <div><?php echo $dateSubmitted->format($formeaConfig->get('date_format', 'F j, Y H:i:s')); ?></div>
        </div>
        <div class="list-group-item d-flex justify-content-between gap-2 align-items-center">
          <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_IP_ADDRESS'); ?></div>
          <div><?php echo $this->item->ip_address; ?></div>
        </div>
        <div class="list-group-item d-flex justify-content-between gap-2 align-items-center">
          <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_LANGUAGE'); ?></div>
          <div><?php echo $this->item->language; ?></div>
        </div>

        <?php if ($this->item->submission_type === SubmissionType::TRANSACTION): ?>
          <div class="list-group-item d-flex justify-content-between gap-2 align-items-center">
            <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_TRANSACTION_ID'); ?></div>
            <div><?php echo $this->item->transaction_no; ?></div>
          </div>
        <?php endif; ?>

        <div class="list-group-item d-flex  gap-2 align-items-center">
          <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_EMAIL_DELIVERY'); ?></div>
          <div class="ms-auto">
            <button class="badge <?php echo $emailStatus->adminBg; ?> px-2" style="border:none;" type="button"
              data-bs-html="true"
              data-bs-toggle="popover" data-bs-trigger="focus"
              data-bs-title="<?php echo Text::_('COM_FORMEA_ADMIN_EMAIL') ?>"
              data-bs-content="<?php echo $emailStatus->adminText; ?>">
              <?php echo Text::_('COM_FORMEA_ADMIN'); ?>
              <i class="<?php echo $emailStatus->adminIcon; ?> ms-2"></i>
            </button>
          </div>
          <div class="vr"></div>
          <div>
            <button class="badge <?php echo $emailStatus->userBg; ?> px-2" style="border:none;" type="button"
              data-bs-html="true"
              data-bs-toggle="popover" data-bs-trigger="focus"
              data-bs-title="<?php echo Text::_('COM_FORMEA_USER_EMAIL') ?>"
              data-bs-content="<?php echo $emailStatus->userText; ?>">
              <?php echo Text::_('COM_FORMEA_USER'); ?>
              <i class="<?php echo $emailStatus->userIcon; ?> ms-2"></i>
            </button>
          </div>
        </div>

        <?php if (!empty($this->item->files)): ?>
          <div class="list-group-item d-block">
            <div class="fs-sm text-muted"><?php echo Text::_('COM_FORMEA_FILES'); ?></div>
            <div class="row">
              <?php foreach ($this->item->files as $file) { ?>
                <div class="col-md-3">
                  <a href="<?php echo $file->url; ?>" download target="_blank" class="formea-file"
                    title="<?php echo $file->name; ?>">
                    <div class="ratio ratio-1x1">
                      <div class="preview <?php echo (!empty($file->thumb_path)) ? 'is-image' : ''; ?>">
                        <?php if (empty($file->thumb_path)): ?>
                          <span class="icn">
                            <?php echo $this->iconSets[$file->icon_name]['svg']; ?>
                          </span>
                        <?php else: ?>
                          <img src="<?php echo $file->url; ?>" alt="">
                        <?php endif; ?>
                      </div>
                    </div>
                    <span class="file-name"><?php echo $file->name; ?></span>
                  </a>
                </div>
              <?php } ?>

            </div>
          </div>
        <?php endif; ?>

      </div>
    </div>
  </div>
  <input type="hidden" name="task" value="">
  <?php echo HTMLHelper::_('form.token'); ?>
</form>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]')
    const popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl));
  });
</script>