<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Feseur\Library\FsrDate;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Formea\Administrator\View\Submissions\HtmlView;

/** @var HtmlView $this */

$user      = Factory::getApplication()->getIdentity();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
?>
<table class="table itemList" id="formeaList">
	<caption class="visually-hidden">
		<?php echo Text::_('COM_FORMEA_TABLE_CAPTION'); ?>,
		<span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
		<span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
	</caption>
	<thead>
		<tr>
			<td class="w-1 text-center">
				<?php echo HTMLHelper::_('grid.checkall'); ?>
			</td>

			<th scope="col">
				<?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_FORM_NAME', 'a.form_title', $listDirn, $listOrder); ?>
			</th>
			<th scope="col">
				<?php echo Text::_('COM_FORMEA_SUBMITTED_BY'); ?>
			</th>
			<th scope="col">
				<?php echo Text::_('COM_FORMEA_DATE_SUBMITTED'); ?>
			</th>
			<?php if ($this->isMultiLang): ?>
				<th scope="col" class="w-3 d-none d-lg-table-cell">
					<?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_LANGUAGE', 'a.language', $listDirn, $listOrder); ?>
				</th>
			<?php endif; ?>
			<th scope="col" class="w-3 d-none d-lg-table-cell">
				<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
			</th>
		</tr>
	</thead>
	<tbody>
		<?php
		foreach ($this->items as $i => $item) :
			$canEdit = $user->authorise('core.edit', 'com_formea.submission.' . $item->id);
			$canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || is_null($item->checked_out);
			$canEditOwn = $user->authorise('core.edit.own', 'com_formea.submission.' . $item->id) && $item->created_by == $userId;
			$canChange = $user->authorise('core.edit.state', 'com_formea.submission.' . $item->id) && $canCheckin;
		?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="text-center">
					<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
				</td>

				<th scope="row" class="has-context">
					<?php if ($item->checked_out) : ?>
						<?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'submissions.', $canCheckin); ?>
					<?php endif; ?>
					<?php $editIcon = '<span class="fa fa-pencil-square me-2" aria-hidden="true"></span>'; ?>
					<a class="hasTooltip"
						href="<?php echo Route::_('index.php?option=com_formea&task=submission.edit&id=' . (int) $item->id); ?>"
						title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape(addslashes($item->form_title)); ?>">
						<?php echo $editIcon; ?><?php echo $this->escape($item->form_title); ?></a>

				</th>
				<td scope="row" class="has-context small">
					<?php if (empty($item->registered_submitter)) {
						echo Text::_('COM_FORMEA_GUEST');
					} else {
						echo $item->registered_submitter;
					} ?>
				</td>
				<td class="small">
					<?php
					$submittedDate = new FsrDate($item->created_date);
					echo $submittedDate->format($this->formeaConfig->get('date_format', 'Y-m-d H:i:s')); ?>
				</td>
				<?php if ($this->isMultiLang): ?>
					<td class="d-none d-md-table-cell">
						<?php echo $item->language; ?>
					</td>
				<?php endif; ?>
				<td class="d-none d-md-table-cell">
					<?php echo $item->id; ?>
				</td>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>