<?php

/**
 * @package     Formea.Plugin
 * @subpackage  element
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
// no direct access
defined('_JEXEC') or die();

use Feseur\Library\FsrOptionTextVal;
use Joomla\Component\Formea\Site\Libraries\FormeaEltype;

class FormeaCheckbox extends FormeaEltype
{
  /**
   * @var string
   * @since 1.0.0
   */
  private $layout = 'stacked';

  /**
   * @var string
   * @since 1.0.0
   */
  private $elementClass = '';

  /**
   * @var bool
   * @since 1.0.0
   */
  private $is_preview = false;

  public function __construct($config = [])
  {
    parent::__construct($config);
  }

  public function getLabel($label = 'label', $class = [], $preview = false)
  {
    return '<label for="' . $this->formatElementId() . '" class="' . implode(' ', $class) . '">' . $label . '</label>';
  }

  public function getInput($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
  {

    $themeClass = $this->getThemeClass();
    if (empty($langTagUnderscore)) {
      $langTagUnderscore = $this->langTagUnderscore;
    }

    $themeClass = $this->getThemeClass();
    if (!empty($this->params)) {
      $this->layout = $this->params->get('layout', 'stacked');
    }
    $this->elementClass = implode(' ', $class);

    $this->is_preview = $preview;


    $submittedData = $this->getSubmittedElementData();

    $default_value = '';
    if (isset($inputAttributes['value'])) {
      $default_value = $inputAttributes['value'];
    }
    $hasError = $submittedData->hasError;
    if ($submittedData->hasSubmittedData) {
      $default_value = $submittedData->submitted_value;
    }

    $error_msg = $submittedData->error_msg;


    $classAttr = [];
    if (!empty($submittedData->error_css_class)) {
      $classAttr[] = $submittedData->error_css_class;
    }


    $input = '<div class="' . $themeClass->getBlockClass() . '">';
    $input .= $this->getOptionLists($langTagUnderscore, $default_value, $submittedData, $error_msg, $hasError);
    $input .= '</div>';


    return $input;
  }

  public function getInputGroup($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
  {
    return '';
  }


  public function getOptionLists($langTagUnderscore = '', $defaultValue = '', $submittedData = null, $error_msg = [], $hasError = false)
  {
    if (empty($langTagUnderscore)) {
      $langTagUnderscore = $this->langTagUnderscore;
    }

    $themeClass = $this->getThemeClass();

    $html                = '';
    $additionalClass     = [];
    $themeContainerClass = $themeClass->getRadioContainerClass(['layout' => $this->layout]);
    if (!empty($themeContainerClass)) {
      $additionalClass[] = $themeContainerClass;
    }

    if (!empty($this->elementClass)) {
      $additionalClass[] = $this->elementClass;
    }
    if (!empty($defaultValue)) {
      if (is_string($defaultValue)) {
        $defaultValue = explode(', ', $defaultValue);
      }
    } else {
      $defaultValue = [];
    }

    if (!empty($this->element_values)) {
      if (isset($this->element_values[$langTagUnderscore])) {
        if (isset($this->element_values[$langTagUnderscore]['option_lists'])) {
          $radioInputClass = [];
          $themeRadioClass = $themeClass->getInputClass('checkbox');
          if (!empty($themeRadioClass)) {
            $radioInputClass[] = $themeRadioClass;
          }
          if (!empty($submittedData)) {
            if ($submittedData->hasError) {
              $radioInputClass[] = $themeClass->getErrorClass();
            } else {
              if ($submittedData->hasSubmittedData) {
                $radioInputClass[] = $themeClass->getNoErrorClass();
              }
            }
          }
          $id = $this->formatElementId();
          /** @var FsrOptionTextVal[] $optionLists */
          $optionLists = $this->element_values[$langTagUnderscore]['option_lists'];
          if (is_countable($optionLists)) {
            $totalOptionLists = count($optionLists);
            for ($i = 0; $i < $totalOptionLists; $i++) {
              $inputId = $id . '_' . $i;
              $html    .= '<div class="' . implode(' ', $additionalClass) . '">';
              $html    .= '<input class="' . implode(' ', $radioInputClass) . '" type="checkbox" ';
              if (!$this->is_preview) {
                $html .= 'name="' . $this->formatElementName() . '" ';
              }
              $html .= 'id="' . $inputId . '" ';
              $html .= 'value="' . htmlspecialchars($optionLists[$i]->val, ENT_QUOTES)  . '" ';
              if (!empty($defaultValue)) {
                if (in_array($optionLists[$i]->val, $defaultValue)) {
                  $html .= 'checked';
                }
              } else {
                if ($optionLists[$i]->selected) {
                  $html .= 'checked ';
                }
              }
              $html .= '/>';
              $html .= '<label class="' . $themeClass->getRadioLabelClass() . '" for="' . $inputId . '">';
              $html .= $optionLists[$i]->text;
              $html .= '</label>';
              /*if ($i == $totalOptionLists - 1)
                {
                  $html .= $this->getErrorMsgFeedback($error_msg, $hasError);
                }*/
              $html .= '</div>';
            }
          }
        }
      }
    }
    // $html .= $this->getErrorMsgFeedback($error_msg, $hasError);

    return $html;
  }

  public function beforeValidatingInput($element)
  {
    if (isset($element->submitted_value)) {
      if (!empty($element->submitted_value)) {
        $element->submitted_value = implode(', ', $element->submitted_value);
      }
    }

    return $element;
  }

  public function preProcessSubmittedValue($submitted_value)
  {
    if (is_array($submitted_value)) {
      $submitted_value = implode(', ', $submitted_value);
    }

    return $submitted_value;
  }

  public function formatElementName()
  {
    $name = parent::formatElementName();

    return $name . '[]';
  }
}
