<?php

/**
 * @package     Formea.Plugin
 * @subpackage  element
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.1.0
 */
// no direct access
defined('_JEXEC') or die();

use Feseur\Library\FsrResponse;
use Joomla\Component\Formea\Site\Libraries\FormeaEltype;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Factory;

class FormeaJoomlaCaptcha extends FormeaEltype
{
  public function __construct($config = [])
  {
    parent::__construct($config);
  }

  public function beforeValidatingInput($element)
  {
    $element->skip_value_store = true;

    return $element;
  }

  public function getLabel($label = 'label', $class = 'form-label', $preview = false)
  {
    return '';
  }

  public function getInput($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
  {
    $input = '';
    if ($preview) {
      $input .= '<img src="' . Joomla\CMS\Uri\Uri::root() . 'media/com_formea/img/element/JoomlaCaptcha/RecaptchaLogo.svg"';
      $input .= 'style="width:100px;"/>';
    } else {
    }

    return $input;
  }

  public function renderField($preview = false, $langTag = '', $columnAttributes = [], $inputAttributes = [], $labelSetting = null)
  {
    $html = '';
    if (!$preview) {
      $elementId      = $this->formatElementId();
      $name           = $this->formatElementName();
      $captchaPlugins = PluginHelper::getPlugin('captcha');
      $globalConfig = Factory::getApplication()->getConfig();
      $globalCaptcha = $globalConfig->get('captcha');
      if (!empty($captchaPlugins) && !empty($globalCaptcha)) {
        $totalCaptchas = count($captchaPlugins);
        for ($i = 0; $i < $totalCaptchas; $i++) {
          if ($captchaPlugins[$i]->name === $globalCaptcha) {
            $submittedData = $this->getSubmittedElementData();
            $hasError      = $submittedData->hasError;
            $error_msg     = $submittedData->error_msg;

            $captha = new Joomla\CMS\Captcha\Captcha($captchaPlugins[$i]->name, json_decode($captchaPlugins[$i]->params, true));
            $captha->initialise($elementId);
            $html = $captha->display($name, $elementId, '');

            $html .= '<div class="fm_feedback_el">' . ($hasError) ? implode('<br/>', $error_msg) : '' . '</div>';
            break;
          }
        }
      }
    } else {
      $html = $this->getInput('', [], $langTag, $preview);
    }

    return $html;
  }

  public function validateInput($submitted_value, $element, $validations = [])
  {
    $retObject      = new FsrResponse();
    $captchaPlugins = PluginHelper::getPlugin('captcha');
    $resultResponse = new FsrResponse();
    $result = (object) [
      'hasError' => true,
      'msg'      => 'Captcha Not Found'
    ];
    if (!empty($captchaPlugins)) {
      if (isset($captchaPlugins[0])) {
        //$app      = Factory::getApplication();
        //$response = $app->getInput()->getString('g-recaptcha-response');
        $response = null;
        if (empty($response)) {
          $response = $submitted_value;
        }
        if (empty($response)) {
          $response = '';
        }
        $captha   = new Joomla\CMS\Captcha\Captcha($captchaPlugins[0]->name, json_decode($captchaPlugins[0]->params, true));
        try {
          $check    = $captha->checkAnswer($response);
          if ($check) {
            $result->hasError = false;
            $result->msg      = '';
            $resultResponse->setSuccess(true);
          } else {
            $result->hasError = true;
            $result->msg      = 'Captcha Failed.';
            $resultResponse->setSuccess(false);
            $resultResponse->setMsg('Captcha Failed.');
          }
        } catch (\Exception $e) {
          $result->hasError = true;
          $result->msg      = $e->getMessage();
          $resultResponse->setSuccess(false);
          $resultResponse->setMsg('Captcha Failed.');
        }
      }
    } else {
      $resultResponse->setSuccess(false);
      $resultResponse->setMsg('Captcha Not Found');
    }
    $resultResponse->setResult($result);
    $retObject->setSuccess(true);
    $retObject->setResult([(object) ['validation_plugin' => 'INTERNALCAPTCHA', 'result' => $resultResponse]]);

    return $retObject;
  }
}
