<?php
	/**
	 * @version     1.0.0
	 * @package     Joomla 4
	 * @subpackage  Formea
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010 - 2020. Feseur Sdn Bhd
	 * @license     GNU/GPL, see LICENSE.php
	 */

	defined('_JEXEC') or die();

	use Joomla\CMS\Factory;
	use Joomla\CMS\WebAsset\WebAssetManager;
	use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;
	use Joomla\Component\Formea\Site\Libraries\FormeaGridItem;
	use Joomla\Component\Formea\Site\Libraries\FormeaTheme;
	use Joomla\Registry\Registry;

	class FormeaBootstrap5 extends FormeaTheme
	{
		private $formTheme;
		private Registry $themeParams;

		public function __construct($config = [])
		{
			parent::__construct($config);
			$this->labelElementClass       = [
				'form-label'
			];
			$this->labelInlineElementClass = [
				'col-form-label'
			];
			$this->elementTypeClass        = [
				'input'    => 'form-control',
				'select'   => 'form-select',
				'textarea' => 'form-control',
				'radio'    => 'form-check-input',
				'checkbox' => 'form-check-input',
				'button'   => 'btn'
			];
			$this->rowClass                = 'row';
			$this->colClass                = 'col';

			if (isset($config['formTheme']))
			{
				$this->formTheme = $config['formTheme'];
				$params          = $this->formTheme->params;
				if ($this->style_id > 0)
				{
					$style = FormeaGeneralHelper::getExtensionStyle($this->style_id);
					if (!empty($style))
					{
						$params = $style->params;
					}
				}
				$this->themeParams = new Registry($params);

				$sizing            = $this->themeParams->get('sizing');
				if (!empty($sizing))
				{
					$this->elementTypeClass['input']    .= ' form-control-' . $sizing;
					$this->elementTypeClass['textarea'] .= ' form-control-' . $sizing;
					$this->elementTypeClass['button']   .= ' btn-' . $sizing;
					$this->elementTypeClass['select']   .= ' form-select-' . $sizing;
				}
			}


			$app = Factory::getApplication();
			/** @var WebAssetManager $wa */
			$wa       = $app->getDocument()->getWebAssetManager();
			$registry = $wa->getRegistry();
			$registry->addRegistryFile('components/com_formea/plugins/theme/Bootstrap5/joomla.asset.json');
		}

		/**
		 * @param                   $page
		 * @param   FormeaGridItem  $item
		 * @param                   $isLast
		 *
		 * @return string
		 *
		 * @since 1.0.0
		 */
		public function drawItem($page, $item, $isLast = false)
		{
			/*$pb = '';
			if (!$isLast)
			{
			  $pb = 'pb-3';
			}*/
			// $html = '<div class="d-block ' . $pb . '">';
			$html = $item->content->input;

			// $html .= '</div>';

			return $html;
		}

    public function getTextAlignClass($position = 'TOP')
    {
      $ret = '';
      switch (strtoupper($position))
      {
        case 'RIGHT':
          $ret = 'text-end';
          break;
        case 'CENTER':
          $ret = 'text-center';
        default:
          $ret = 'text-start';
      }

      return $ret;
    }

    public function getFormGroupClass()
    {
     return '';
    }

    public function getBlockClass()
		{
			return 'd-block';
		}

		public function getErrorClass()
		{
			return 'is-invalid';
		}

		public function getRadioContainerClass($param = [])
		{
			$layout = 'stacked';
			$str    = ['form-check'];
			if (isset($param['layout']))
			{
				$layout = $param['layout'];
			}
			switch ($layout)
			{
				case 'inline':
					$str[] = 'form-check-inline';
					break;
				case 'stacked_reverse':
					$str[] = 'form-check-reverse';
					break;
				case 'inline_reverse':
					$str[] = 'form-check-inline';
					$str[] = 'form-check-reverse';
					break;
				default;
			}

			return implode(' ', $str);
		}

		public function getRadioLabelClass($param = [])
		{
			return 'form-check-label';
		}

		public function getLoadableScript()
		{
			$ret = [];
			if ((int) $this->themeParams->get('load_js', 1) > 0)
			{
				$ret[] = 'com_formea.theme.bootstrap5.bootstrap';
			}

			return $ret;
		}

		public function getLoadableStyle()
		{
			$ret = [];
			if ((int) $this->themeParams->get('load_bs', 1) > 0)
			{
				$ret[] = 'com_formea.theme.bootstrap5.bootstrap';
			}
			if ((int) $this->themeParams->get('load_bs_formea', 1) > 0)
			{
				$ret[] = 'com_formea.theme.bootstrap5.formea';
			}

			return $ret;
		}


	}
