<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Parser\CommentStrategy;

use Egulias\EmailValidator\EmailLexer;
use Egulias\EmailValidator\Result\Result;
use Egulias\EmailValidator\Result\ValidEmail;
use Egulias\EmailValidator\Warning\CFWSNearAt;
use Egulias\EmailValidator\Result\InvalidEmail;
use Egulias\EmailValidator\Result\Reason\ExpectingATEXT;

class LocalComment implements CommentStrategy
{
	/**
	 * @var array
	 */
	private $warnings = [];

	public function exitCondition(EmailLexer $lexer, int $openedParenthesis): bool
	{
		return !$lexer->isNextToken(EmailLexer::S_AT);
	}

	public function endOfLoopValidations(EmailLexer $lexer): Result
	{
		if (!$lexer->isNextToken(EmailLexer::S_AT)) {
			return new InvalidEmail(new ExpectingATEXT('ATEX is not expected after closing comments'), ((array) $lexer->token)['value']);
		}
		$this->warnings[CFWSNearAt::CODE] = new CFWSNearAt();

		return new ValidEmail();
	}

	public function getWarnings(): array
	{
		return $this->warnings;
	}
}
