<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Parser;

use Egulias\EmailValidator\EmailLexer;
use Egulias\EmailValidator\Result\Result;
use Egulias\EmailValidator\Result\ValidEmail;
use Egulias\EmailValidator\Result\InvalidEmail;
use Egulias\EmailValidator\Result\Reason\ExpectingATEXT;

class IDRightPart extends DomainPart
{
	protected function validateTokens(bool $hasComments): Result
	{
		$invalidDomainTokens = [
			EmailLexer::S_DQUOTE      => true,
			EmailLexer::S_SQUOTE      => true,
			EmailLexer::S_BACKTICK    => true,
			EmailLexer::S_SEMICOLON   => true,
			EmailLexer::S_GREATERTHAN => true,
			EmailLexer::S_LOWERTHAN   => true,
		];

		if (isset($invalidDomainTokens[((array) $this->lexer->token)['type']])) {
			return new InvalidEmail(new ExpectingATEXT('Invalid token in domain: ' . ((array) $this->lexer->token)['value']), ((array) $this->lexer->token)['value']);
		}

		return new ValidEmail();
	}
}
