<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Parser;

use Egulias\EmailValidator\EmailLexer;
use Egulias\EmailValidator\Result\InvalidEmail;
use Egulias\EmailValidator\Result\Reason\ConsecutiveDot;
use Egulias\EmailValidator\Result\Result;
use Egulias\EmailValidator\Result\ValidEmail;
use Egulias\EmailValidator\Warning\Warning;

abstract class PartParser
{
	/**
	 * @var array
	 */
	protected $warnings = [];

	/**
	 * @var EmailLexer
	 */
	protected $lexer;

	public function __construct(EmailLexer $lexer)
	{
		$this->lexer = $lexer;
	}

	abstract public function parse(): Result;

	/**
	 * @return Warning[]
	 */
	public function getWarnings()
	{
		return $this->warnings;
	}

	protected function parseFWS(): Result
	{
		$foldingWS      = new FoldingWhiteSpace($this->lexer);
		$resultFWS      = $foldingWS->parse();
		$this->warnings = array_merge($this->warnings, $foldingWS->getWarnings());

		return $resultFWS;
	}

	protected function checkConsecutiveDots(): Result
	{
		if (((array) $this->lexer->token)['type'] === EmailLexer::S_DOT && $this->lexer->isNextToken(EmailLexer::S_DOT)) {
			return new InvalidEmail(new ConsecutiveDot(), ((array) $this->lexer->token)['value']);
		}

		return new ValidEmail();
	}

	protected function escaped(): bool
	{
		$previous = $this->lexer->getPrevious();

		return $previous && $previous['type'] === EmailLexer::S_BACKSLASH
			&&
			((array) $this->lexer->token)['type'] !== EmailLexer::GENERIC;
	}
}
