<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Result;

interface Result
{
	/**
	 * Is validation result valid?
	 */
	public function isValid(): bool;

	/**
	 * Is validation result invalid?
	 * Usually the inverse of isValid()
	 */
	public function isInvalid(): bool;

	/**
	 * Short description of the result, human readable.
	 */
	public function description(): string;

	/**
	 * Code for user land to act upon.
	 */
	public function code(): int;
}
