<?php

/**
 * This is a forked library modified for use in Formea extension,
 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
 * See LICENSE
 *
 * @version     1.0.0
 * @package     Formea Email Validation
 * @subpackage  Lexer
 * @author      Feseur Sdn Bhd
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Egulias\EmailValidator\Validation;

use Egulias\EmailValidator\EmailLexer;
use Egulias\EmailValidator\MessageIDParser;
use Egulias\EmailValidator\Result\InvalidEmail;
use Egulias\EmailValidator\Result\Reason\ExceptionFound;
use Exception;

class MessageIDValidation implements EmailValidation
{

	/**
	 * @var array
	 */
	private $warnings = [];

	/**
	 * @var ?InvalidEmail
	 */
	private $error;

	public function isValid(string $email, EmailLexer $emailLexer): bool
	{
		$parser = new MessageIDParser($emailLexer);
		try {
			$result         = $parser->parse($email);
			$this->warnings = $parser->getWarnings();
			if ($result->isInvalid()) {
				/** @psalm-suppress PropertyTypeCoercion */
				$this->error = $result;

				return false;
			}
		} catch (Exception $invalid) {
			$this->error = new InvalidEmail(new ExceptionFound($invalid), '');

			return false;
		}

		return true;
	}

	public function getWarnings(): array
	{
		return $this->warnings;
	}

	public function getError(): ?InvalidEmail
	{
		return $this->error;
	}
}
