<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Site\Controller;

defined('_JEXEC') or die;


use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\Component\Formea\Site\Model\GroupedelementModel;
use Joomla\Input\Input;


class GroupedelementController extends BaseController
{
	/**
	 * Constructor.
	 *
	 * @param   array                     $config   An optional associative array of configuration settings.
	 *                                              Recognized key values include 'name', 'default_task',
	 *                                              'model_path', and 'view_path' (this list is not meant to be
	 *                                              comprehensive).
	 * @param   ?MVCFactoryInterface      $factory  The factory.
	 * @param   ?CMSApplicationInterface  $app      The Application for the dispatcher
	 * @param   ?Input                    $input    Input
	 *
	 * @since   3.0
	 */
	public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null)
	{
		parent::__construct($config, $factory, $app, $input);
	}

	public function getGroupedElement()
	{
		$this->checkToken('get') or die('Invalid Token');
		$return_url = $this->input->getString('return_url');

		/** @var GroupedelementModel $model */
		$model         = $this->getModel('Groupedelement', '', []);
		$view          = $this->getView('Groupedelement', 'raw');
		$view->element = $model->getElementGroup();

		// Display the view
		$view->display();
	}
}
