<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Site\Libraries;

defined('_JEXEC') or die;

class FormeaLayoutElement
{
	public int $id = 0;
	public int $element_id = 0;
	public int $group_id = 0;
	public string $type;
	public string $title;
	public string $alias;
	public string $content;
	public bool $used = false;
	public bool $selected = false;
	public bool $isGroup = false;
	public int $state = 0;
	public float $w = 12;
	public float $x = 0;
	public float $y = 0;
	public float $h = 1;
	public float $maxH = 1;
	public float $minH = 1;

	public array $labelSettings;
	public array $imageDetails = [
		'image'     => '',
		'imageSafe' => '',
		'imageType' => 0
	];
	public string $elementTypeTitle = '';
	public int $value_type = 0;
	public int $eltype_id = 0;

	public function __construct($config)
	{
		if (isset($config['isGroup'])) {
			$this->isGroup = $config['isGroup'];
		}

		if (isset($config['id'])) {
			$this->id = $config['id'];
		}
		if (isset($config['element_id'])) {
			$this->element_id = $config['element_id'];
		}
		if (isset($config['group_id'])) {
			$this->group_id = $config['group_id'];
		}
		if (isset($config['type'])) {
			$this->type = $config['type'];
		}
		if (isset($config['state'])) {
			$this->state = (int) $config['state'];
		}
		if (isset($config['title'])) {
			$this->title = $config['title'];
		}
		if (isset($config['alias'])) {
			$this->alias = $config['alias'];
		}
		if (isset($config['content'])) {
			$this->content = $config['content'];
		}
		if (isset($config['used'])) {
			$this->used = $config['used'];
		}
		if (isset($config['w'])) {
			$this->w = $config['w'];
		}
		if (isset($config['x'])) {
			$this->x = $config['x'];
		}
		if (isset($config['y'])) {
			$this->y = $config['y'];
		}
		if (isset($config['h'])) {
			$this->h = $config['h'];
		}
		if (isset($config['maxH'])) {
			$this->maxH = $config['maxH'];
		}
		if (isset($config['minH'])) {
			$this->minH = $config['minH'];
		}
		/*if (isset($config['preview']))
			{
			  $this->preview = $config['preview'];
			}
			if (isset($config['previewSafe']))
			{
			  $this->previewSafe = $config['previewSafe'];
			}
			if (isset($config['elementDetails']))
			{
			  $this->elementDetails = $config['elementDetails'];
			}*/
		if (isset($config['labelSettings'])) {
			$this->labelSettings = $config['labelSettings'];
		}

		if (isset($config['imageDetails'])) {
			$this->imageDetails = $config['imageDetails'];
		}
		if (isset($config['elementTypeTitle'])) {
			$this->elementTypeTitle = $config['elementTypeTitle'];
		}
		if (isset($config['eltype_id'])) {
			$this->eltype_id = $config['eltype_id'];
		}
		if (isset($config['value_type'])) {
			$this->value_type = $config['value_type'];
		}
	}

	public function set($key, $value)
	{
		$this->{$key} = $value;
	}
}
