<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Site\Libraries;

use stdClass;

class FormeaSubmissionResponse
{

  /**
   * Url where the source of the submission is made
   * @var string
   * @since 1.1.0
   */
  public $url = '';

  /**
   * @var boolean
   * @since 1.1.0
   */
  public $hasError = true;

  /**
   * @var FormeaSubmissionElement[]
   * @since 1.1.0
   */
  public $elements = [];

  /**
   * @var stdClass
   * @since 1.1.0
   */
  public $submission;

  /**
   * @var stdClass
   * @since 1.1.0
   */
  public $submissionMsgs;

  /**
   * @var boolean
   * @since 1.1.0
   */
  public $redirect = false;

  /**
   * @var string
   * @since 1.1.0
   */
  public $redirectUrl = '';

  /**
   * @var string
   * @since 1.1.0
   */
  public $redirectAwayUrl = '';

  /**
   * Type of redirection. 0 - internal | 1 - redirect out | 2 - redirect out for form submission
   * @var boolean
   * @since 1.1.0
   */
  public $redirectType = 0;

  /**
   * redirect method. GET|POST
   * @var string
   * @since 1.1.0
   */
  public $redirectMethod = 'POST';

  /**
   * redirect page title
   * @var string
   * @since 1.1.0
   */
  public $redirectTitle = 'Redirecting you';

  /**
   * redirect description
   * @var string
   * @since 1.1.0
   */
  public $redirectDescription = 'Loading. Please wait..';

  /**
   * key-value pair of parameters required for redirectType 2
   * @var array
   * @since 1.1.3
   */
  public $redirectParams = [];

  /**
   * @var string
   * @since 1.1.3
   */
  public $afterSubmission = '';


  public function __construct($conf = [])
  {
    $paramKey = [
      'url',
      'hasError',
      'elements',
      'submission',
      'submissionMsgs',
      'redirect',
      'redirectUrl',
      'afterSubmission'
    ];
    foreach ($paramKey as $param) {
      if (isset($conf[$param])) {
        $this->{$param} = $conf[$param];
      }
    }
  }
}
