<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Site\Model;

defined('_JEXEC') or die;

use Exception;
use Feseur\Library\FsrResponse;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseModel;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Formea\Site\Libraries\FormeaForm;
use Joomla\Registry\Registry;
use Joomla\Session\SessionInterface;

/**
 * Formea model for the Joomla Formea component.
 *
 * @since  1.0.0
 */
class ValidateformModel extends BaseModel
{
  /**
   * @var string item
   */
  protected $_item = null;


  public function __construct($config = [], MVCFactoryInterface $factory = null)
  {
    parent::__construct($config, $factory);
  }


  /**
   *
   * @return FsrResponse
   *
   * @throws Exception
   * @since 1.0.0
   */
  public function validatePage()
  {
    $app   = Factory::getApplication();
    $input = $app->getInput();

    $retObject = new FsrResponse();
    try {
      $form_id = $input->getInt('fom', 0);
      if ($form_id < 1) {
        throw new Exception(Text::_('COM_FORMEA_INVALID_FORM'));
      }

      $formeaToken = $input->get('fomToken', null);
      if (empty($formeaToken)) {
        throw new Exception(Text::_('COM_FORMEA_FORM_NOT_FOUND'));
      }

      $formeaToken = base64_decode($formeaToken);

      $formeaToken = $input->get('fomToken', null);

      if (empty($formeaToken)) {
        throw new Exception(Text::_('COM_FORMEA_FORM_NOT_FOUND'));
      }
      $honeyPot = $input->get('formea_name');
      if (!empty($honeyPot)) {
        throw new Exception(Text::_('COM_FORMEA_INVALID_SUBMISSION'));
      }

      $page_index = $input->getInt('current_page', -1);

      if ($page_index < 0) {
        throw new Exception(Text::_('COM_FORMEA_INVALID_SECTION'));
      }
      $formea = $input->get('formea', [], 'array');

      $formeaFiles = $input->files->get('formea');
      if (!empty($formeaFiles)) {
        $formea = array_merge($formea, $formeaFiles);
      }

      if (empty($formea)) {
        throw new Exception(Text::_('COM_FORMEA_EMPTY_SUBMISSION'));
      }


      $formeaForm = new FormeaForm(['id' => $form_id]);
      $formObject = $formeaForm->getObject();
      if (empty($formObject)) {
        throw new Exception(Text::_('COM_FORMEA_FORM_NOT_FOUND'));
      }
      $retObject = $formeaForm->validatePage($page_index, $formea, $formeaToken);
    } catch (Exception $e) {
      $retObject->setMsg($e->getMessage());
    }

    return $retObject;
  }

  /**
   *
   * @return FsrResponse
   *
   * @throws Exception
   * @since 1.0.6
   */
  public function validateForm()
  {
    $app   = Factory::getApplication();
    $input = $app->getInput();

    $retObject = new FsrResponse();
    try {
      $form_id = $input->getInt('fom', 0);
      if ($form_id < 1) {
        throw new Exception(Text::_('COM_FORMEA_INVALID_FORM'));
      }
      $formeaToken = $input->get('fomToken', null);
      if (empty($formeaToken)) {
        throw new Exception(Text::_('COM_FORMEA_FORM_NOT_FOUND'));
      }

      $formeaToken = $input->get('fomToken', null);
      if (empty($formeaToken)) {
        throw new Exception(Text::_('COM_FORMEA_FORM_NOT_FOUND'));
      }
      $honeyPot = $input->get('formea_name');
      if (!empty($honeyPot)) {
        throw new Exception(Text::_('COM_FORMEA_INVALID_SUBMISSION'));
      }

      $return_url = $input->getString('return_url');
      if (!empty($return_url)) {
        $return_url = base64_decode($return_url);
      } else {
        $return_url = Uri::root();
      }

      $formeaToken = base64_decode($formeaToken);


      $formea = $input->get('formea', [], 'array');


      $formeaFiles = $input->files->get('formea');
      if (!empty($formeaFiles)) {
        $formea = array_merge($formea, $formeaFiles);
      }

      if (empty($formea)) {
        throw new Exception(Text::_('COM_FORMEA_EMPTY_SUBMISSION'));
      }


      $formeaForm = new FormeaForm(['id' => $form_id, 'uniqueString' => $formeaToken]);
      $formObject = $formeaForm->getObject();
      if (empty($formObject)) {
        throw new Exception(Text::_('COM_FORMEA_FORM_NOT_FOUND'));
      }
      $retObject = $formeaForm->validateForm($formea, $formeaToken, $return_url);
    } catch (Exception $e) {
      $retObject->setMsg($e->getMessage());
    }

    return $retObject;
  }
}
