<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Formea\Site\View\Formea\HtmlView;

/** @var HtmlView $this */
$uniqueString = $this->form->getUniqueString();

$formeaToken = base64_encode($uniqueString);
$hiddenClass = '';
if (!empty($this->submissionData)) {
  if ($this->submissionData->submissionMsgs->message_type === 'html') { ?>
    <div style="display: block;margin:15px 0;">
      <?php if ($this->submissionData->hasError) {
        echo $this->submissionData->submissionMsgs->global_error_msg;
      } else {
        echo $this->submissionData->submissionMsgs->submission_msg;
      } ?>
    </div>
<?php }
  if ($this->submissionData->afterSubmission === 'hide') {
    $hiddenClass = 'formea-hidden';
  }
}
?>

<?php if ((int) $this->item->allow_submission > 0): ?>
  <form action="<?php echo Uri::current() ?>" enctype="multipart/form-data"
    id="formea_form_<?php echo $uniqueString; ?>"
    class="formea-form <?php echo $this->item->params->get('form_class', null);
                        echo $hiddenClass; ?>"
    <?php echo $this->item->params->get('form_attributes', null); ?> method="post">
  <?php else: ?>
    <div id="formea_form_<?php echo $uniqueString; ?>"
      class="formea-form <?php echo $this->item->params->get('form_class', null);
                          echo $hiddenClass; ?>"
      <?php echo $this->item->params->get('form_attributes', null); ?>>
    <?php endif; ?>



    <?php if (!empty($this->item->details->get('form_heading'))): ?>
      <h5><?php echo $this->item->details->get('form_heading'); ?></h5>
    <?php endif; ?>
    <?php
    echo $this->form->renderForm($this->item->elementLayouts);
    ?>


    <?php echo $this->item->honeypot; ?>
    <input type="hidden" name="fom" value="<?php echo $this->item->id; ?>">
    <?php if ((int) $this->item->allow_submission > 0): ?>
      <input type="hidden" name="return_url" value="<?php echo base64_encode(Uri::current()); ?>">
      <?php echo HTMLHelper::_('form.token'); ?>
      <input type="hidden" name="fomToken" value="<?php echo $formeaToken; ?>">
      <input type="hidden" name="option" value="com_formea">
      <input type="hidden" name="task" value="formea.submit">
  </form>
<?php else: ?>
  </div>
<?php endif; ?>

<?php
/*	echo $this->item->event->afterDisplayTitle;
	echo $this->item->event->beforeDisplayContent;
	echo $this->item->event->afterDisplayContent;*/
